﻿Namespace ESRI.BAOnline.SOAP
    ''' <summary>
    ''' This provider requests for a new token using HTTPS SSL connection.
    ''' </summary>
    Public Class HTTPTokenProvider
        Inherits TokenProvider
        Private tokenServiceUrl As String
        Private username As String
        Private password As String
        Private format As String = "request=getToken&username={0}&password={1}"

        ''' <summary>
        ''' Constructs a new token provider.
        ''' </summary>
        ''' <param name="tokenServiceUrl">Token service URL.</param>
        ''' <param name="username">User name.</param>
        ''' <param name="password">Password.</param>
        Public Sub New(ByVal tokenServiceUrl As String, ByVal username As String, ByVal password As String)
            Me.tokenServiceUrl = tokenServiceUrl
            Me.username = username
            Me.password = password
        End Sub

        ''' <summary>
        ''' Gets or sets the query format string.
        ''' </summary>
        ''' <remarks>The default query format is "request=getToken&amp;username={0}&amp;password={1}".</remarks>
        Public Property QueryFormat() As String
            Get
                Return format
            End Get
            Set(ByVal value As String)
                format = value
            End Set
        End Property

        ''' <summary>
        ''' Creates a new token.
        ''' </summary>
        Public Overrides Sub UpdateToken()
            CurrentToken = GetToken(tokenServiceUrl, String.Format(format, username, password))
        End Sub
    End Class
End Namespace