using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SOAPClient
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            wsmap.NorthAmerica_MapServer mapserver = new wsmap.NorthAmerica_MapServer();
            // Define a url to the SOAP endpoint for any map service
            mapserver.Url = "http://serverapps.esri.com/arcgis/services/SamplesNET/NorthAmerica/MapServer";
                     
            // Start with the default map description from the default map (data frame)
            wsmap.MapServerInfo mapinfo = mapserver.GetServerInfo(mapserver.GetDefaultMapName());
            wsmap.MapDescription mapdesc = mapinfo.DefaultMapDescription;

            // Define the image format and return type
            wsmap.ImageType imgtype = new wsmap.ImageType();
            imgtype.ImageFormat = wsmap.esriImageFormat.esriImageJPG;
            imgtype.ImageReturnType = wsmap.esriImageReturnType.esriImageReturnURL;

            // Define the size and DPI (to calculate scale on the server)
            wsmap.ImageDisplay imgdisp = new wsmap.ImageDisplay();
            imgdisp.ImageHeight = pictureBox1.Height;
            imgdisp.ImageWidth = pictureBox1.Width;
            imgdisp.ImageDPI = 96;

            // Define the map image properties
            wsmap.ImageDescription imgdesc = new wsmap.ImageDescription();
            imgdesc.ImageDisplay = imgdisp;
            imgdesc.ImageType = imgtype;

            // Generate a map
            wsmap.MapImage mapimg = mapserver.ExportMapImage(mapdesc, imgdesc);

            // Get the map image and display in the .NET PictureBox control
            System.Net.HttpWebRequest webreq = 
                (System.Net.HttpWebRequest)System.Net.WebRequest.Create(mapimg.ImageURL);
            System.Net.HttpWebResponse webresp = 
                (System.Net.HttpWebResponse)webreq.GetResponse();
            System.Drawing.Image img = System.Drawing.Image.FromStream(webresp.GetResponseStream());
            pictureBox1.Image = img;
        }
    }
}